/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.analysis.dpEngine.DpeStats;
import ibm.nways.analysis.dpManager.Admin.DpAdminPanel;
import ibm.nways.analysis.dpManager.Admin.DpeMonitor;
import ibm.nways.analysis.dpManager.Admin.NetworkDisplay;
import ibm.nways.analysis.dpManager.Admin.NetworkNode;
import ibm.nways.analysis.dpManager.Admin.PanViewCanvas;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.nhm.eui.NhmHelpRef;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;

public class DPETopology
extends Panel
implements JCActionListener {
    private DpeMonitor dpeMon;
    private NetworkDisplay ND;
    private PanViewCanvas Panorama;
    private ScrollPane scroll;
    private BorderLayout bLayout;
    private Panel buttonPanel;
    private JCButton refreshButton;
    private JCButton helpButton;
    private Label messageLabel;
    private Applet appl;
    private NetworkNode aNode;
    private NetworkNode uaNode;
    private NetworkNode serverNode;
    private Vector assignedDPEsVector;
    private Vector unAssignedDPEsVector;
    private Vector assNodeStorage;
    private Vector unAssNodeStorage;
    private static final int white = 0;
    private static final int green = 1;
    private static final int yellow = 2;
    private static final int red = 3;
    private static final int blue = 4;
    private static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    private static final String REFRESH_BUTTON_LABEL = adminRB.getString("s_Refresh");
    private static final String HELP_BUTTON_LABEL = adminRB.getString("s_Help");

    public DPETopology(NetworkDisplay networkDisplay, Applet applet) {
        this.appl = applet;
        this.ND = networkDisplay;
        this.bLayout = new BorderLayout();
        this.setLayout(this.bLayout);
        this.refreshButton = new JCButton(REFRESH_BUTTON_LABEL);
        this.refreshButton.addActionListener(this);
        this.helpButton = new JCButton(HELP_BUTTON_LABEL);
        this.helpButton.addActionListener(this);
        this.buttonPanel = new Panel();
        this.buttonPanel.add(this.refreshButton);
        this.buttonPanel.add(this.helpButton);
        this.scroll = new ScrollPane();
        this.Panorama = new PanViewCanvas(this);
        this.assignedDPEsVector = new Vector();
        this.unAssignedDPEsVector = new Vector();
        this.assNodeStorage = new Vector();
        this.unAssNodeStorage = new Vector();
        this.updateDPEInfo();
        this.scroll.add(this.Panorama);
        this.add("Center", this.scroll);
        this.add("South", this.buttonPanel);
    }

    public DpAdminPanel getAdminPanel() {
        return this.ND.getDpAdminRef();
    }

    public NetworkDisplay getNDRef() {
        return this.ND;
    }

    public PanViewCanvas getCanvas() {
        return this.Panorama;
    }

    public NetworkNode getServerNode() {
        return this.serverNode;
    }

    public void setServerNodePosition(int n, int n2) {
        this.serverNode.setNodeX(n);
        this.serverNode.setNodeY(n2);
    }

    public void createServerNode(String string) {
        this.serverNode = new NetworkNode(string);
        this.serverNode.setNodeColor(0);
    }

    public void createUnAssignedNetworkNode(String string) {
        this.uaNode = new NetworkNode(string);
        this.uaNode.setNodeColor(4);
        this.unAssNodeStorage.addElement(this.uaNode);
    }

    public void createAssignedNetworkNode(String string) {
        Hashtable hashtable = null;
        DpeStats dpeStats = null;
        String string2 = null;
        this.aNode = new NetworkNode(string);
        hashtable = this.ND.getDpeStatsTable();
        if (hashtable.size() != 0) {
            string2 = this.ND.giveHostNameGetIp(string);
            dpeStats = (DpeStats)hashtable.get(string2);
        }
        if (dpeStats != null) {
            if (dpeStats.healthCounter <= 50 && dpeStats.healthCounter >= 0) {
                this.aNode.setNodeColor(1);
            } else if (dpeStats.healthCounter < 0 && dpeStats.healthCounter >= -25) {
                this.aNode.setNodeColor(2);
            } else {
                this.aNode.setNodeColor(3);
            }
        }
        this.assNodeStorage.addElement(this.aNode);
    }

    public void updateDPEInfo() {
        String string;
        Enumeration enumeration;
        if (this.assNodeStorage.size() != 0) {
            this.assNodeStorage.removeAllElements();
        }
        if (this.unAssNodeStorage.size() != 0) {
            this.unAssNodeStorage.removeAllElements();
        }
        if (this.assignedDPEsVector.size() != 0) {
            this.assignedDPEsVector.removeAllElements();
        }
        if (this.unAssignedDPEsVector.size() != 0) {
            this.unAssignedDPEsVector.removeAllElements();
        }
        this.ND.updateDPEInformation();
        this.assignedDPEsVector = this.ND.getAssignedDPEs();
        this.unAssignedDPEsVector = this.ND.getUnAssignedDPEs();
        if (this.assignedDPEsVector.size() == 0) {
            this.Panorama.repaint();
        } else {
            enumeration = this.assignedDPEsVector.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                this.createAssignedNetworkNode(string);
            }
        }
        if (this.unAssignedDPEsVector.size() == 0) {
            this.Panorama.repaint();
            return;
        }
        enumeration = this.unAssignedDPEsVector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.createUnAssignedNetworkNode(string);
        }
    }

    public Vector getAssNodeStorage() {
        return this.assNodeStorage;
    }

    public Vector getUnAssNodeStorage() {
        return this.unAssNodeStorage;
    }

    public void adjustUnAssNodeStorage(NetworkNode networkNode) {
        this.unAssNodeStorage.removeElement(networkNode);
    }

    public void wipeCanvas() {
        Graphics graphics = this.Panorama.getGraphics();
        this.Panorama.clearCanvas(graphics);
    }

    public void updateDpeTop() {
        this.updateDPEInfo();
        this.wipeCanvas();
        this.Panorama.repaint();
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.refreshButton) {
            this.refreshButton.setEnabled(false);
            this.updateDpeTop();
            DpeMonitor dpeMonitor = this.ND.getDpeMonRef();
            dpeMonitor.updateDpeMon();
            this.refreshButton.setEnabled(true);
            return;
        }
        if (jCActionEvent.getSource() == this.helpButton) {
            NhmHelpRef nhmHelpRef = new NhmHelpRef(this);
            if (this.appl instanceof BrowserApplet) {
                BrowserApplet browserApplet = (BrowserApplet)this.appl;
                browserApplet.showHelp(nhmHelpRef);
                return;
            }
            this.appl.getAppletContext().showDocument(nhmHelpRef.getURL(this.appl));
        }
    }
}

